	subroutine ASSEMBLE(iout, idbg, Ne, Nn, Nd, NnNd, &
			vA, vL, vB, vQc1, vQd1, vQc2, vQd2, &
			rA, rL, rB, rQc1, rQd1, rQc2, rQd2, &
			cA, cL, cB, cQc1, cQd1, cQc2, cQd2, &
			lastA, lastL, lastB, lastQc1, lastQd1, lastQc2, lastQd2, &
			Ae, Le, Be, Qce1, Qde1, Qce2, Qde2, ie, nmat, e)
! assemble arrays

	implicit none
	integer iout, idbg
	integer Ne, Nn, Nd, NnNd		! array parameters
	integer lastA, lastL, lastB, lastQc1, lastQd1, lastQc2, lastQd2
	real*8 Ae(4,4), Le(4,4), Be(4,4)	! element arrays
	real*8 Qce1(4,4), Qde1(4,4)		! element arrays
	real*8 Qce2(4,4), Qde2(4,4)		! element arrays
	integer ie(Ne,5)			! global connectivity array
	integer nmat(Nn,0:Nd)			! global nodal materials array
	integer rA (Nn+1), rL (Nn+1), rB(Nn+1)! global  arrays (compact rows)
	integer cA (NnNd), cL (NnNd), cB(NnNd)! global  arrays (compact columns)
	integer rQc1(Nn+1), rQd1(Nn+1)		! global  arrays (compact rows)
	integer rQc2(Nn+1), rQd2(Nn+1)		! global  arrays (compact rows)
	integer cQc1(NnNd), cQd1(NnNd)		! global  arrays (compact columns)
	integer cQc2(NnNd), cQd2(NnNd)		! global  arrays (compact columns)
	real*8 vA (NnNd), vL (NnNd), vB(NnNd)	! global  arrays (compact values)
	real*8 vQc1(NnNd), vQd1(NnNd)		! global  arrays (compact values)
	real*8 vQc2(NnNd), vQd2(NnNd)		! global  arrays (compact values)
	integer e

	integer i, j

!	write(idbg,'(a)') ' --- ASSEMBLE ---'	! ### TEMPORARY ###

! assemble rank 2 sparse arrays
	do i = 1,4
	  do j = 1,4
	    call ASSEMBLE2(iout, idbg, Nn, NnNd, lastA, vA, cA, rA, &
			ie(e,i), ie(e,j), Ae(i,j), 1)
	    call ASSEMBLE2(iout, idbg, Nn, NnNd, lastL, vL, cL, rL, &
			ie(e,i), ie(e,j), Le(i,j), 1)
	    call ASSEMBLE2(iout, idbg, Nn, NnNd, lastB, vB, cB, rB, &
			ie(e,i), ie(e,j), Be(i,j), 1)
	  enddo		! j
	enddo		! i

! average rank 2 sparse arrays
	do i = 1,4
	  do j = 1,4
	    call ASSEMBLE2(iout, idbg, Nn, NnNd, lastQc1, vQc1, cQc1, rQc1, &
		ie(e,i), ie(e,j), Qce1(i,j), nmat(ie(e,i),0))	! advection  comp. 1
	    call ASSEMBLE2(iout, idbg, Nn, NnNd, lastQd1, vQd1, cQd1, rQd1, &
		ie(e,i), ie(e,j), Qde1(i,j), nmat(ie(e,i),0))	! dispersion comp. 1
	    call ASSEMBLE2(iout, idbg, Nn, NnNd, lastQc2, vQc2, cQc2, rQc2, &
		ie(e,i), ie(e,j), Qce2(i,j), nmat(ie(e,i),0))	! advection  comp. 2
	    call ASSEMBLE2(iout, idbg, Nn, NnNd, lastQd2, vQd2, cQd2, rQd2, &
		ie(e,i), ie(e,j), Qde2(i,j), nmat(ie(e,i),0))	! dispersion comp. 2
	  enddo		! j
	enddo		! i
				
	return
	end
